-- [ja] 情報読み込み 
-- [ja] DrillCategory時とは違い、選択中のカテゴリのみ代入済み 
local drFile={};
local drInfo={};
drFile=getenv("drFile");
drInfo=getenv("drInfo");
local lvInfo={};
lvInfo=getenv("lvInfo");
DrillDificultyInit();
local lvScore=getenv("lvScore");

-- [ja] システム的にキー操作を受け付けるタイミング 
local sys_key=false;
-- [ja] キャンセルボタンを押し続けているか確認用変数 
local sys_backcnt=0;
-- [ja] 決定ボタンを押してからの時間確認用変数 
local sys_startcnt=0;
-- [ja] 現在選択中の番号（1～数） 
local sys_sellevel;
	if not getenv("sys_sellevel") then
		sys_sellevel=1;
	else
		sys_sellevel=getenv("sys_sellevel");
	end;
	setenv("sys_sellevel",sys_sellevel);

setenv("sys_selected",false); -- [ja] 決定ボタン押下時 
setenv("sys_move","nil");
local sys_offcommand=false;	-- [ja] OffCommand実行時にtrue
local pn=getenv("DrillPlayer");
setenv("sys_error",false);	-- [ja] 楽曲が見つからないなどエラー時にtrue、この状態だと選択できなくする 

local snd_cancel=false;
local snd_start=false;
local snd_chglevel=false
local t=Def.ActorFrame{};
-- [ja] サウンドとキー操作　
t[#t+1] = Def.ActorFrame {
	OnCommand=function(self)
		SOUND:PlayAnnouncer("-waiei ScreenSelectDrillDifficulty intro");
		self:sleep(EXF_BEGIN_WAIT()+0.5);
		self:queuecommand("KeyUnLock");
	end;
	KeyUnLockCommand=function(self)
		sys_key=true;
	end;
	CodeCommand=function(self,params)
		if sys_key and GAMESTATE:IsHumanPlayer(params.PlayerNumber) and sys_extype~="song" then
			local p=(params.PlayerNumber==PLAYER_1) and 1 or 2;
			if params.Name == 'BackD' then
				if sys_startcnt==0 and sys_backcnt==0 then
					sys_backcnt=20;
				end;
			elseif params.Name=="BackU" and sys_backcnt>0 then
				sys_backcnt=0;
			elseif (params.Name=="Start" or params.Name=="Center") and not sys_offcommand then
				if not getenv("sys_error") then
					setenv("sys_selected",true);
				end;
				snd_start=true;
			elseif (params.Name == 'Left' or params.Name == 'Left2'
				or params.Name == 'Left3' or params.Name == 'Left4') and sys_startcnt==0 then
				sys_sellevel=sys_sellevel-1;
				if sys_sellevel<1 then
					sys_sellevel=drInfo["Level"];
				end;
				snd_chglevel=true;
				setenv("sys_sellevel",sys_sellevel);
				setenv("sys_move","right");
			elseif (params.Name == 'Right' or params.Name == 'Right2'
				or params.Name == 'Right3' or params.Name == 'Right4') and sys_startcnt==0 then
				sys_sellevel=sys_sellevel+1;
				if sys_sellevel>drInfo["Level"] then
					sys_sellevel=1;
				end;
				snd_chglevel=true;
				setenv("sys_sellevel",sys_sellevel);
				setenv("sys_move","left");
			elseif params.Name=="Select" and not sys_offcommand then
				setenv("DrillOptions_Return","ScreenSelectDrillDifficulty");
				SCREENMAN:AddNewScreenToTop("ScreenDrillOptions");
			end;
		end;
	end;
	OffCommand=function(self)
		sys_key=false;
		--[[
			ここで情報設定 
		--]]
		local tmp=split(":",lvInfo[""..sys_sellevel.."-Song"][1]);
		tmp[1]=string.gsub(tmp[1],"\\","/");
		local path=split("/",tmp[1]);
		if #path<2 then
			self:queuecommand("ReStartScreen");
		else
			lvScore[""..sys_sellevel.."-PlayCnt"]=lvScore[""..sys_sellevel.."-PlayCnt"]+1;
			setenv("lvScore",lvScore);
			SetDrillLife();
			setenv("sys_sellevel",sys_sellevel);
			setenv("DrillStage",1);
			setenv("DrillMaxStage",#(lvInfo[""..sys_sellevel.."-Song"]));
			setenv("DrillChk","SetStage1");
			setenv("DrillRealTimeOpt",((drInfo["ROpt"]=="true") and true or false));
			InitDrillScore(getenv("DrillMaxStage"));
			SetDrillLife();
			SOUND:PlayAnnouncer("-waiei ScreenSelectDrillDifficulty comment");
			self:sleep(1.0);
			self:queuecommand("NextScreen");
		end;
	end;
	NextScreenCommand=function(self)
		SCREENMAN:SetNewScreen("ScreenSelectMusic");
	end;
	ReStartScreenCommand=function(self)
		SCREENMAN:SetNewScreen("ScreenSelectDrillDifficulty");
	end;
	Def.Actor{
		SetCommand=function(self)
			setenv("sys_error",false);
			local str="";
			for i=1,#lvInfo[""..sys_sellevel.."-Song"] do
				local _,s,d=GetDrillSong(lvInfo[""..sys_sellevel.."-Song"][i]);
				if str~="" then str=str.."\n\n"; end;
				if not s then
					setenv("sys_error",true);
					break;
				end;
			end;
		end;
	};
};
-- [ja] 決定 
t[#t+1] = LoadActor(THEME:GetPathS("Common","start")) .. {
	Name="SND_START";
	PlayCommand=function(self)
		self:stop();
		self:play();
		snd_start=false;
	end;
};
t[#t+1] = LoadActor(THEME:GetPathS("Common","value")) .. {
	Name="SND_CHGDIF";
	PlayCommand=function(self)
		self:stop();
		self:play();
		snd_chgdif=false;
	end;
};
t[#t+1] = LoadActor(THEME:GetPathS("Common","Cancel")) .. {
	Name="SND_CANCEL";
	PlayCommand=function(self)
		self:stop();
		--self:play();
		snd_cancel=false;
		SCREENMAN:GetTopScreen():Cancel();
	end;
};
t[#t+1] = LoadActor(THEME:GetPathS("MusicWheel","change")) .. {
	Name="SND_CHGSONG";
	PlayCommand=function(self)
		self:stop();
		self:play();
		snd_chglevel=false;
	end;
};

local oTime=0;
local nTime=0;
local m=PREFSMAN:GetPreference("MenuTimer");
local mTimer=tonumber(THEME:GetMetric("ScreenSelectDrillDifficulty","TimerSeconds"));
local wait=1.0/60;
local function update(self,dt)
	nTime=nTime+dt;
	if m and (mTimer-nTime)<=0 and not sys_offcommand then
		snd_start=true;
		setenv("sys_selected",true);
	end;
	-- [ja] 1回分の処理 
	if nTime-oTime>wait then
		if sys_backcnt>0 then
			sys_backcnt=sys_backcnt-1;
			if sys_backcnt<=0 then
				snd_cancel=true;
			end;
		end;
		if getenv("sys_selected") and not sys_offcommand then
			sys_offcommand=true;
			self:queuecommand("Off");
		end;
		if snd_cancel then
			local c_snd=self:GetChild("SND_CANCEL");
			c_snd:queuecommand("Play");
		end;
		if snd_start then
			local c_snd=self:GetChild("SND_START");
			c_snd:queuecommand("Play");
		end;
		if snd_chglevel then
			local c_snd=self:GetChild("SND_CHGSONG");
			c_snd:queuecommand("Play");
			self:queuecommand("Set");
		end;
		oTime=oTime+wait;
	end;
end;

t.InitCommand=cmd(SetUpdateFunction,update);

return t;